@echo off
	set ISAACDIR=steamapps\common\The Binding of Isaac Rebirth
	set ISAACEXE=isaac-ng.exe
	set ISAACSIZE=2718736
	
	for /F "usebackq tokens=2,* skip=2" %%L in (`reg query "HKCU\Software\Valve\Steam" /v SteamPath`) do set STEAMPATH=%%M

	if not exist "%STEAMPATH%\%ISAACDIR%\%ISAACEXE%" goto parsecfg
	set ok=1
	call :install "%STEAMPATH%\%ISAACDIR%"
	goto finish

:parsecfg
	set STEAMCFG="%STEAMPATH%\config\config.vdf"

	for /F "usebackq tokens=1,2" %%A in (`findstr /lc:"BaseInstallFolder_" %STEAMCFG%`) do (
		if exist "%%~B\%ISAACDIR%\%ISAACEXE%" (
			set ok=1
			call :install "%%~B\%ISAACDIR%"
		)
	)

:finish
	if defined ok (echo Done!) else (echo Failed to find %ISAACEXE%)
	pause
	goto end

:install
	set ISAACPATH=%~1
	echo Installing to:
	echo %ISAACPATH%
	echo =====================================
	
:loop
	call :setsize "%ISAACPATH%\%ISAACEXE%"
	if NOT %size% EQU %isaacsize% (
		echo Please uninstall Afterbirth from your Steam library then press any key...
		pause >nul
		goto :loop
	)
	
	pushd "%~dp0"
	set ZHLPATH=%CD%
	cd /D %ISAACPATH%
	
	mkdir Antibirth 2> nul
	mkdir Antibirth\resources 2> nul
	mkdir Antibirth\resources\packed 2> nul
	
	for /F "tokens=*" %%A in (%ZHLPATH%\files\files.txt) do (
		copy "%%A" "Antibirth\%%A"
	)
	
	for /F "tokens=*" %%A in (%ZHLPATH%\files\modfiles.txt) do (
		copy "%ZHLPATH%\files\%%A" "Antibirth\%%A"
	)
	
	set "ISAACPATH=%ISAACPATH:/=\%"
	echo "%ISAACPATH%\Antibirth"
	explorer "%ISAACPATH%\Antibirth"
	goto :end

:setsize
	set size=%~z1
	goto :end

:end
